/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards.colorless;

import com.megacrit.cardcrawl.actions.unique.AttackFromDeckToHandAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;

public class SecretWeapon
extends AbstractCard {
    public static final String ID = "Secret Weapon";
    private static final CardStrings cardStrings = CardCrawlGame.languagePack.getCardStrings("Secret Weapon");
    public static final String NAME = SecretWeapon.cardStrings.NAME;
    public static final String DESCRIPTION = SecretWeapon.cardStrings.DESCRIPTION;
    public static final String UPGRADE_DESCRIPTION = SecretWeapon.cardStrings.UPGRADE_DESCRIPTION;
    private static final int POOL = 1;

    public SecretWeapon() {
        super(ID, NAME, "colorless/skill/secretWeapon", "colorless/skill/secretWeapon", 0, DESCRIPTION, AbstractCard.CardType.SKILL, AbstractCard.CardColor.COLORLESS, AbstractCard.CardRarity.RARE, AbstractCard.CardTarget.NONE, 1);
        this.exhaust = true;
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m) {
        AbstractDungeon.actionManager.addToBottom(new AttackFromDeckToHandAction(1));
    }

    @Override
    public boolean canUse(AbstractPlayer p, AbstractMonster m) {
        boolean canUse = super.canUse(p, m);
        if (!canUse) {
            return false;
        }
        boolean hasAttack = false;
        for (AbstractCard c : p.drawPile.group) {
            if (c.type != AbstractCard.CardType.ATTACK) continue;
            hasAttack = true;
        }
        if (!hasAttack) {
            this.cantUseMessage = UPGRADE_DESCRIPTION;
            canUse = false;
        }
        return canUse;
    }

    @Override
    public AbstractCard makeCopy() {
        return new SecretWeapon();
    }

    @Override
    public void upgrade() {
    }
}

